//
//  MCReportDataInfo.h
//  MCReporting
//
//  Created by Alykhan Jetha on 06/11/05.
//  Copyright 2005 Marketcircle Inc.. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class MCReportElement;
@class MCReportGenerator;

@class MCReportDataInfoPlugin;

/*
typedef enum _MCReportDataFetchType {
	MCReportDataNoFetchSpecifiedType = 0,
	MCReportDataKeyPathFetchType,
	MCReportDataQualifierFetchType,
	MCReportDataSQLFetchType,
	MCReportDataScriptEvalFetchType,
}MCReportDataFetchType;
*/

@interface MCReportDataInfo : NSObject {
	
	NSMutableArray *dataInfoPlugins;
	NSMutableArray *humanEntrySortDescriptors;
	
	NSMutableArray *customFields;
	
	MCReportElement *reportElement; // weak ref
	
	BOOL usesResultingFieldsFromParent;
}

+ (MCReportDataInfo *)infoWithName:(NSString *)aName displayName:(NSString *)aDisplayName resultKindName:(NSString *)resultName toMany:(BOOL)many reportElement:(MCReportElement *)aElement;

	/*
	 Prepare an array of report infos that are expected while starting a report for layout. If a aKind is nil, the 'objects' or 'object' data info is not created.
	 */
+ (NSMutableArray *)prepareIncomingDataInfosWithObjectsType:(NSString *)aKind behavior:(NSString *)behav reportElement:(MCReportElement *)aElement;

- (id)initWithReportElement:(MCReportElement *)aElement;

- (MCReportElement *)reportElement;
- (void)setReportElement:(MCReportElement *)aElement;

// get the first parent data info through the report element
- (MCReportDataInfo *)parentFirstDataInfo;
- (MCReportDataInfo *)anyParentDataInfoForKey:(NSString *)aKey;

- (MCReportDataInfoPlugin *)addDataInfoPluginWithClass:(Class)aClass;
- (MCReportDataInfoPlugin *)addDataInfoPluginWithClassname:(NSString *)aClassname;

- (void)addDataInfoPlugin:(MCReportDataInfoPlugin *)aPlug;

- (MCReportDataInfoPlugin *)firstDataInfoPluginOfClass:(Class)aClass;
- (MCReportDataInfoPlugin *)firstDataInfoPluginOfClass:(Class)aClass createIfNotFound:(BOOL)create;

- (MCReportDataInfoPlugin *)lastDataInfoPlugin;

// Conveniences - covers methods from the lastDataInfoPlugin
- (NSString *)name;
- (NSString *)displayName;
- (NSString *)resultKindName;
- (BOOL)isToMany;
- (NSString *)relativePrefix;
- (BOOL)hasScript;

- (BOOL)keyPathContains:(NSString *)aKeyPath;
- (BOOL)replaceKeyPath:(NSString *)aKeyPath withKeyPath:(NSString *)aNewKeyPath;

- (NSMutableArray *)customFields;
- (void)setCustomFields:(NSMutableArray *)aCustomFields;

- (BOOL)usesResultingFieldsFromParent;
- (void)setUsesResultingFieldsFromParent:(BOOL)flag;

// If we have custom fields, returns those, if not, looks for fieldsResultKind and returns fields for that type 
- (NSArray *)resultingFields;

- (NSMutableArray *)humanEntrySortDescriptors;
- (void)setHumanEntrySortDescriptors:(NSMutableArray *)aHumanEntrySortDescriptors;
- (void)makeHumanEntrySortDescriptorsFromSortDescriptors:(NSArray *)descripts;
- (void)addHumanEntrySortDescriptor:(id)anHumanEntrySortDescriptor;
- (void)removeHumanEntrySortDescriptor:(id)anHumanEntrySortDescriptor;

- (NSMutableArray *)dataInfoPlugins;
- (void)setDataInfoPlugins:(NSMutableArray *)aDataInfoPlugins;
- (void)replaceDataInfoPlugin:(MCReportDataInfoPlugin *)aPlugin with:(MCReportDataInfoPlugin *)another;

// evaluates the rule and puts the result into reportData on the element
- (id)evaluateForReportElement:(MCReportElement *)aReportElement 
				 reportGenerator:(MCReportGenerator *)rgen;

@end
